/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mesh mesh; // sample mesh
Gfx  gfx ; // sky box texture
/******************************************************************************/
void InitPre()
{
   App.name="Rendering Sky";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.mode(800,600);
   ViewportFull.range=20; // set initial viewport range to 20 meters to see sky fog when zoomed out
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=6;

   // create mesh
   mesh.create(1).B(0).create(Ball(1),VTX_TX0|VTX_NRM|VTX_TNG);
   mesh.setMaterial(Materials("../data/mtrl/brick/0.mtrl")).setRender().setBox();

   // import skybox
   gfx.Import("../data/gfx/sky/skybox.jpg",GFX_A8R8G8B8,GFX_CUBE);   

   // set default sky
   Sky.set();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(2.5,18,CAMH_ZOOM|CAMH_ROT);

   if(Kb.bp(KB_1))Sky.clear(                                       ); // disable sky
   if(Kb.bp(KB_2))Sky.set  (Vec(0.35,0.45,0.64),Vec(0.30,0.38,0.54)); // set sky from colors
   if(Kb.bp(KB_3))Sky.set  (gfx                                    ); // set sky from skybox

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         REPD(x,3)
         REPD(z,3)mesh.draw(Matrix(1,Vec(x-1,0,z-1)*3));
      break;

      case RM_LIGHT:
         LightDir(1,!Vec(1,-1,1)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,"Press 1,2,3 for different skies");
}
/******************************************************************************/
